README Windows
==============

The simplyCAN software package is delivered as .zip archive, which includes the following components:
* simplyCAN library (dll, static lib)
* Header file
* BusMonitor executable
* FlashTool executable
* Demo applications for C, C# and Python
* Driver (.inf file)
* API documentation
* License


Installation
------------

For installation instructions, please refer to `doc\4.01.0001.22001-simplyCAN-en.pdf`


Usage of the Flashtool
------------------

If a firmware update will be available, the flash tool can be used to update the firmware.

```
Syntax:
  scflash <serial-port> <file-name>

Example:
  scflash COM5 update.hfu
```


Usage of the simplyCAN library
------------------------------

* Open existing or create a new project for your application
* Copy simply.h, from the inc\ directory, into your project and make sure that the location where 
  the file reside appears in the 'Additional Include Directories' section (Configuration Properties -> 
  C/C++ -> General).
* Copy the .lib file from lib\static\ into your project and add 'simplyCAN.lib' to your 'Additional 
  Dependencies' (Configuration Properties -> Linker -> Input)
  Also make sure that the directory where simplyCAN.lib resides is added to 'Additional Library 
  Directories' (Configuration Properties -> Linker -> General)
* If you use the static version of the simplyCAN library, make sure that 'Runtime Library' is set to 
  'Multi-threaded (/MT)' (Configuration Properties -> C/C++ -> Code Generation).
* Compile and run your application. If you use the DLL version of simplyCAN, remember that you 
  need to have a copy of the DLL either in the runtime directory or in system32.


Usage of the Demo Applications
------------------------------

The demo applications are available for C, C# and Python. First the serial port has to be adapted 
according to your hardware setup. To determine the used serial port, you can:

- use the simplyCAN bus monitor
- use the Windows device manager
- use the function `retrieve_serial_port()` (C and Python)


### C Demo
* Adapt the `k_SERIAL_PORT` and `k_BAUDRATE` defines in `demo.c` according to your hardware setup:
  ```c
  #ifdef __unix__
  #define k_SERIAL_PORT      "/dev/ttyACM0"
  #else
  #define k_SERIAL_PORT      "COM1"
  #endif
  #define k_BAUDRATE         (250)
  ```
* Compile and run the application using the Visual Studio project `demo.vcxproj`


### C# Demo

* The C# demo is developed for .NET Core 2.0 from Microsoft.
  To run and build the demo application the [.NET Core Runtime](https://dotnet.microsoft.com/download) is required.
* Adapt the name of the DLL that provides the simplyCAN API in `simply.cs` according to your system:
  ```csharp
  public const string SimplyCANlib = "simplyCAN.dll";    //  Windows 32bit
  public const string SimplyCANlib = "simplyCAN-64.dll"; //  Windows 64bit
  public const string SimplyCANlib = "simplyCAN.so";     //  ELF 64bit
  ```
* Adapt `mserial_port` and `mbitrate` in `demo.cs` according to your hardware setup:
  ```csharp
  //private static char[] mserial_port = "/dev/ttyACM0\0".ToCharArray();   // Linux
  private static char[] mserial_port = "COM5\0".ToCharArray();   // Windows
  private static ushort mbitrate = 250;
  ```
* Run the demo with `dotnet run demo.csproj`.


### VB.NET Demo

* The VB demo is developed for .NET4 from Microsoft.
  To run and build the demo application, Visual Studio 2013 or newer is required.
* Adapt the name of the DLL that provides the simplyCAN API in `simply.vb` according to your system:
  ```vbnet
  Public Const SimplyCANlib As String = "simplyCAN.dll"     ' Windows 32bit
  Public Const SimplyCANlib As String = "simplyCAN-64.dll"  ' Windows 64bit
  ```
* Adapt `mserial_port` and `mbitrate` in `demo.vb` according to your hardware setup:
  ```vbnet
  Dim comPort As String = "COM5"
  Dim mbitrate As UShort = 500
  ```
* Run the demo with `dotnet run demo.vbproj`.


### Python Demo

* Adapt the COM port and the baudrate in `demo.py` according to your hardware setup:
  ```
  # main("/dev/ttyACM0", 250)    # for Linux
  main("COM6", 250)         # for Windows
  ```
  The value `250` is the used baudrate in kBaud.

* Run the demo with `py demo.py`.


Copyright
---------

(C) 2019-2022 HMS Technology Center Ravensburg GmbH<br>
Helmut-Vetter-Strasse 2<br>
88213 Ravensburg<br>
Germany